#include  <stdio.h>
#ifdef _WIN32
  #include  <windows.h>
#else
  #include  <string>
  #include  <unistd.h>
#endif
#include  "include\\strlib.h"
//    :
#define STORE_HOST "127.0.0.1"
#define STORE_PORT "62222"
// 
#define CCERTIFICATE "MIICxTCCAm6gAwIBAgIgzTwle8CkqUG6HiBJktl0cfgg51ewTnL0DJYvhaplVlIwDgYKKwYBBAG1EQECAgUAMDM\
                      xEDAOBgNVBAMUB0FETUlOQ0ExEjAQBgNVBAoTCUdBTU1BVEVDSDELMAkGA1UEBhMCS1owIhgPMjAwODAxMDEwMT\
                      AxMDFaGA8yMDE4MDEwMTAxMDEwMVowMzEQMA4GA1UEAxQHQURNSU5DQTESMBAGA1UEChMJR0FNTUFURUNIMQswC\
                      QYDVQQGEwJLWjBjMA4GCisGAQQBtREBAgIFAANRAAYCAAA6qgAAAEVDMQACAADw2qYY1mq4OVlDu7PpgXZc8zZs\
                      hw6tM0INZDijLHnLOkSe+SaJGDBqd4gbOy2nGvRY3/fu4sLIJi8mUQVsPFjbo4IBQDCCATwwVQYDVR0jBE4wTIA\
                      gzTwle8CkqUG6HiBJktl0cfgg51ewTnL0DJYvhaplVlKhBocEfwAAAYIgzTwle8CkqUG6HiBJktl0cfgg51ewTn\
                      L0DJYvhaplVlIwKQYDVR0OBCIEIM08JXvApKlBuh4gSZLZdHH4IOdXsE5y9AyWL4WqZVZSMA4GA1UdDwEBAQQEA\
                      wIBBjASBgNVHRMBAQEECDAGAQEBAgECMIGTBgNVHSAEgYswgYgwgYUGCCsGAQQBtREDMHkwHwYIKwYBBQUHAgEW\
                      E2h0dHA6Ly93d3cuZ2FtbWEua3owVgYIKwYBBQUHAgIwSjAcFhXNyMsgw+Ds7OAg0uX17e7r7uPo/y4wAwIBARo\
                      qz/Do7OXwIO/u6+jy6OroIOjx7+7r/Ofu4uDt6P8g8eXw8uj06Org8uAuMA4GCisGAQQBtREBAgIFAANBAPzmGi\
                      BKNMZtSDuuPLgGIqzR+pP9a8SWdn+Z6pzrLbGiY5MRymCwl8TZxjOkIvJZzsv7ggxHqkkCS44SuEDSUDI="
//  
#define CRL          "MIIBKTCB0wIBATAOBgorBgEEAbURAQICBQAwMzEQMA4GA1UEAxQHQURNSU5DQTESMBAGA1UEChMJR0FNTUFURUN\
                      IMQswCQYDVQQGEwJLWhgPMjAwODAxMDEwMTAxMDFaGA8yMDA5MDEwMTAxMDEwMVowAKBlMGMwCgYDVR0UBAMCAQ\
                      EwVQYDVR0jBE4wTIAgzTwle8CkqUG6HiBJktl0cfgg51ewTnL0DJYvhaplVlKhBocEfwAAAYIgzTwle8CkqUG6H\
                      iBJktl0cfgg51ewTnL0DJYvhaplVlIwDgYKKwYBBAG1EQECAgUAA0EAOupS/vGyJ0RbFil5JI64Bi4P4A0ktGTh\
                      rO26G5BqgQAIsESh0WNqXnO7xeHGvSDe9xA4D4OfIjauNSdZ3YQrZg=="
//------------------------------------------------------------------------------
int main(void)
{
int ret  = 0;
int code = 0;
hCERTSTORE hStore = 0;
HCRYPTPROV hP     = 0;
unsigned char *binCert=NULL;
unsigned char *binCRL=NULL;
long CRLSize;
long binSize;
try
{
  //  
  code = CSPOpenContext(&hP,NULL, 25, 0, CRYPT_VERIFYCONTEXT, NULL, 0, NULL, 0, NULL);
  if( code )
  {
    printf("%s [CSPOpenContext: error = %d]\n",ErrorString(code), code);
    throw code;
  }
  //  
  code = CrtOpenStore(CRT_STORE_PROV_LDAP, hP, 0, false, NULL, &hStore);
  if( code )
  {
    printf("%s [CrtOpenStore: error = %d]\n",ErrorString(code), code);
    throw code;
  }
  binCert = (unsigned char*) calloc (sizeof(CCERTIFICATE),sizeof(unsigned char));
  code = BaseToBin ((unsigned char*)CCERTIFICATE, sizeof(CCERTIFICATE), binCert, &binSize);
  if (code) 
  {
    printf("%s [BaseToBin: error = %d]\n",ErrorString(code), code);
    throw code;
  }
  binCRL = (unsigned char*) calloc (sizeof(CRL),sizeof(unsigned char));
  code = BaseToBin ((unsigned char*)CRL, sizeof(CRL), binCRL, &CRLSize);
  if (code) 
  {
    printf("%s [BaseToBin: error = %d]\n",ErrorString(code), code);
    throw code;
  }
  //  
  code = CrptVerifyCRLSignature (hStore, binCRL, CRLSize, binCert, binSize);
  if (code)
  {
    printf("%s [CrptVerifyCRLSignature: error = %d]\n",ErrorString(code), code);
    throw code;
  }
  printf("VerifyCRLSignature = OK\n");
}
catch(int er){ret=er;}
if (binCert) free (binCert);
if (binCRL) free (binCRL);
//  
if( hStore ) 
{
  CrtCloseStore(&hStore); 
  hStore = (hCERTSTORE) NULL;
}
//  
if( hP )
{
  CSPCloseContext(&hP); 
  hP = (HCRYPTPROV) NULL;
}
return ret;
}
